/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.specialty;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import net.minecraft.class_10034;
import net.minecraft.class_11659;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_9848;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.cache.model.BakedGeoModel;
import software.bernie.geckolib.cache.model.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.base.BoneSnapshots;
import software.bernie.geckolib.renderer.base.RenderPassInfo;

public abstract class DyeableGeoArmorRenderer<T extends class_1792, R extends class_10034>
extends GeoArmorRenderer<T, R> {
    protected final Set<GeoBone> dyeableBones = new ReferenceOpenHashSet();
    protected @Nullable BakedGeoModel lastModel = null;

    public DyeableGeoArmorRenderer(GeoModel<T> model) {
        super(model);
    }

    protected abstract boolean isBoneDyeable(GeoBone var1);

    protected int getColorForBone(R renderState, GeoBone bone, int baseColour) {
        return baseColour;
    }

    @Override
    public int getRenderColor(T animatable, GeoArmorRenderer.RenderData stackAndSlot, float partialTick) {
        return -1;
    }

    @Override
    public void preRenderPass(RenderPassInfo<R> renderPassInfo, class_11659 renderTasks) {
        super.preRenderPass(renderPassInfo, renderTasks);
        this.checkBoneDyeCache(renderPassInfo);
        for (GeoBone bone : this.dyeableBones) {
            renderPassInfo.addPerBoneRender(bone, (renderPassInfo1, bone1, renderTasks1) -> {
                class_10034 renderState = (class_10034)renderPassInfo1.renderState();
                int renderColor = renderPassInfo1.renderColor();
                class_1921 renderType = this.getRenderType(renderState, this.getTextureLocation(renderState));
                if (renderType != null) {
                    renderTasks1.method_73483(renderPassInfo1.poseStack(), renderType, (pose, vertexConsumer) -> this.renderDyedBone(renderState, pose, bone1, renderPassInfo1, vertexConsumer, renderColor));
                }
            });
        }
    }

    protected void renderDyedBone(R renderState, class_4587.class_4665 pose, GeoBone bone1, RenderPassInfo<R> renderPassInfo1, class_4588 vertexConsumer, int renderColor) {
        class_4587 poseStack = new class_4587();
        poseStack.method_23760().method_66521(pose);
        bone1.render(renderPassInfo1, new class_4587(), vertexConsumer, renderPassInfo1.packedLight(), renderPassInfo1.packedOverlay(), class_9848.method_61322((int)renderColor, (int)this.getColorForBone(renderState, bone1, (Integer)renderState.getOrDefaultGeckolibData(DataTickets.RENDER_COLOR, (Object)-1))));
    }

    @Override
    public void adjustModelBonesForRender(RenderPassInfo<R> renderPassInfo, BoneSnapshots snapshots) {
        for (GeoBone bone : this.dyeableBones) {
            snapshots.get(bone).skipRender(true);
        }
    }

    protected void checkBoneDyeCache(RenderPassInfo<R> renderPassInfo) {
        BakedGeoModel model = renderPassInfo.model();
        if (model != this.lastModel) {
            this.lastModel = model;
            this.dyeableBones.clear();
            this.collectDyeableBones(model.topLevelBones());
        }
    }

    protected void collectDyeableBones(GeoBone[] bones) {
        for (GeoBone bone : bones) {
            if (this.isBoneDyeable(bone)) {
                this.dyeableBones.add(bone);
            }
            this.collectDyeableBones(bone.children());
        }
    }
}

